/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMutexImpWin32.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CMutexImpWin32_h	// [
#define Included_CMutexImpWin32_h

#include "pgpClassesConfig.h"
#include "CMutexImp.h"

_PGP_BEGIN

// Class CMutexImpWin32

class CMutexImpWin32 : public CMutexImp
{
	friend class CPFLImpFactoryWin32;

private:
	CMutexImpWin32();
	~CMutexImpWin32();

	PGPUInt32	Enter(PGPInt32 timeout);
	void		Leave();

private:
	HANDLE	mMutexHandle;
};


// Class CMutexImpWin32 member functions

inline 
CMutexImpWin32::CMutexImpWin32()
{
	mMutexHandle = CreateMutex(NULL, FALSE, NULL);

	if (IsNull(mMutexHandle))
		THROW_ERRORS(kPGPError_SyncObjOpFailed, GetLastError());
}

inline 
CMutexImpWin32::~CMutexImpWin32()
{
	CloseHandle(mMutexHandle);
	mMutexHandle = NULL;
}

inline 
PGPUInt32 
CMutexImpWin32::Enter(PGPInt32 msTimeout)
{
	if (msTimeout == CMutex::InfiniteTimeout)
		msTimeout = INFINITE;

	return WaitForSingleObjectEx(mMutexHandle, msTimeout, FALSE);
}

inline 
void 
CMutexImpWin32::Leave()
{
	ReleaseMutex(mMutexHandle);
}

_PGP_END

#endif	// ] Included_CMutexImpWin32_h
